/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HObject;
import java.lang.reflect.Array;

public class HArrayList
implements Cloneable {
    private static final int DEFAULT_CAPACITY = 4;
    protected HObject[] a;
    protected int len;

    public HArrayList() {
        this(4, false);
    }

    protected HArrayList(HObject[] hObjectArray) {
        this.len = hObjectArray.length;
    }

    public HArrayList(int n, boolean bl) {
        this.a = new HObject[n];
        this.len = bl ? n : 0;
    }

    public HArrayList(HArrayList hArrayList) {
        this.len = hArrayList.len;
        this.a = new HObject[this.len];
        System.arraycopy(hArrayList.a, 0, this.a, 0, this.len);
    }

    public void add(int n, HObject hObject) {
        this.ensureCapacity(this.len + 1);
        System.arraycopy(this.a, n, this.a, n + 1, this.len - n);
        this.a[n] = hObject;
        ++this.len;
    }

    public final void add(HObject hObject) {
        this.add(this.len, hObject);
    }

    public boolean addAll(int n, HArrayList hArrayList) {
        int n2 = hArrayList.len;
        if (n2 == 0) {
            return true;
        }
        this.ensureCapacity(this.len + n2);
        System.arraycopy(this.a, n, this.a, n + n2, this.len - n);
        System.arraycopy(hArrayList.a, 0, this.a, n, n2);
        this.len += n2;
        return true;
    }

    public final boolean addAll(HArrayList hArrayList) {
        return this.addAll(this.len, hArrayList);
    }

    public final void clear() {
        this.len = 0;
    }

    public Object clone() {
        HArrayList hArrayList;
        try {
            hArrayList = (HArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        hArrayList.a = new HObject[this.len];
        System.arraycopy(this.a, 0, hArrayList.a, 0, this.len);
        return hArrayList;
    }

    public final boolean contains(HObject hObject) {
        return this.indexOf(hObject) != -1;
    }

    public void ensureCapacity(int n) {
        int n2;
        if (this.a.length >= n) {
            return;
        }
        for (n2 = 16; n2 != Integer.MIN_VALUE && n2 - 12 < n; n2 <<= 1) {
        }
        if (n2 == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("too big");
        }
        int n3 = n2 - 12;
        HObject[] hObjectArray = new HObject[n3];
        System.arraycopy(this.a, 0, hObjectArray, 0, this.len);
        this.a = hObjectArray;
    }

    public final HObject get(int n) {
        return this.a[n];
    }

    public final HObject get(int n, int n2) {
        return ((HArrayList)((Object)this.a[n])).a[n2];
    }

    public final HObject get(int n, int n2, int n3) {
        return ((HArrayList)((Object)((HArrayList)((Object)this.a[n])).a[n2])).a[n3];
    }

    public HObject[] getA() {
        return this.a;
    }

    public int indexOf(HObject hObject) {
        for (int i = 0; i < this.len; ++i) {
            if (!(hObject == null ? this.a[i] == null : hObject.equals(this.a[i]))) continue;
            return i;
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.len == 0;
    }

    public int lastIndexOf(HObject hObject) {
        for (int i = this.len - 1; i >= 0; --i) {
            if (!(hObject == null ? this.a[i] == null : hObject.equals(this.a[i]))) continue;
            return i;
        }
        return -1;
    }

    public HObject remove(int n) {
        HObject hObject = this.a[n];
        this.removeRange(n, n + 1);
        return hObject;
    }

    protected void removeRange(int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        System.arraycopy(this.a, n2, this.a, n, this.len - n2);
        this.len -= n3;
    }

    public final HObject set(int n, int n2, int n3, HObject hObject) {
        HObject hObject2 = ((HArrayList)((Object)((HArrayList)((Object)this.a[n])).a[n2])).a[n3];
        ((HArrayList)((Object)((HArrayList)((Object)this.a[n])).a[n2])).a[n3] = hObject;
        return hObject2;
    }

    public final HObject set(int n, int n2, HObject hObject) {
        HObject hObject2 = ((HArrayList)((Object)this.a[n])).a[n2];
        ((HArrayList)((Object)this.a[n])).a[n2] = hObject;
        return hObject2;
    }

    public final HObject set(int n, HObject hObject) {
        HObject hObject2 = this.a[n];
        this.a[n] = hObject;
        return hObject2;
    }

    public void setA(HObject[] hObjectArray) {
        this.a = hObjectArray;
    }

    public final int size() {
        return this.len;
    }

    public void sort() {
        boolean bl = false;
        if (this.size() > 1) {
            int n;
            int n2 = 1;
            int n3 = n = this.size() - 1;
            do {
                HObject hObject;
                HObject hObject2;
                int n4;
                for (n4 = n; n4 >= n2; --n4) {
                    hObject2 = this.get(n4 - 1);
                    hObject = this.get(n4);
                    if (!hObject.less(hObject2)) continue;
                    bl = true;
                    this.set(n4 - 1, hObject);
                    this.set(n4, hObject2);
                    n3 = n4;
                }
                for (n4 = n2 = n3 + 1; n4 <= n; ++n4) {
                    hObject2 = this.get(n4 - 1);
                    hObject = this.get(n4);
                    if (!hObject.less(hObject2)) continue;
                    bl = true;
                    this.set(n4 - 1, hObject);
                    this.set(n4, hObject2);
                    n3 = n4;
                }
            } while (n2 <= (n = n3 - 1));
        }
    }

    public HObject[] toArray() {
        HObject[] hObjectArray = new HObject[this.len];
        System.arraycopy(this.a, 0, hObjectArray, 0, this.len);
        return hObjectArray;
    }

    public HObject[] toArray(HObject[] hObjectArray) {
        if (hObjectArray.length < this.len) {
            hObjectArray = (HObject[])Array.newInstance(hObjectArray.getClass().getComponentType(), this.len);
        }
        System.arraycopy(this.a, 0, hObjectArray, 0, this.len);
        if (hObjectArray.length > this.len) {
            hObjectArray[this.len] = null;
        }
        return hObjectArray;
    }

    public void trimToSize() {
        if (this.len != this.a.length) {
            HObject[] hObjectArray = new HObject[this.len];
            System.arraycopy(this.a, 0, hObjectArray, 0, this.len);
            this.a = hObjectArray;
        }
    }
}

