/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;

public class HMatrix {
    HFunction matrix;

    public HMatrix(HFunction hFunction) {
        this.matrix = hFunction;
    }

    public final HMatrix copy(int n) {
        HFunction hFunction = new HFunction(this.matrix.head(), this.matrix.size());
        hFunction.prop = n;
        for (int i = 0; i < this.matrix.size(); ++i) {
            hFunction.set(i, (HObject)((HFunction)this.matrix.get(i)).clone());
        }
        return new HMatrix(hFunction);
    }

    public HFunction get(int n) {
        return (HFunction)this.matrix.get(n);
    }

    public HObject get(int n, int n2) {
        return ((HFunction)this.matrix.get(n)).get(n2);
    }

    public final HFunction getFunction() {
        return this.matrix;
    }

    public HFunction set(int n, HFunction hFunction) {
        HFunction hFunction2 = (HFunction)this.matrix.a[n];
        this.matrix.a[n] = hFunction;
        return hFunction2;
    }

    public void set(HObject hObject, int n, int n2) {
        ((HFunction)this.matrix.get(n)).set(n2, hObject);
    }

    public int size() {
        return this.matrix.size();
    }

    public HDoubleComplex[][] toDoubleComplexMatrixArray() {
        if (this.matrix.len == 0) {
            throw new HThrowException(C.Error, C.List, new HString("size = 0"));
        }
        int n = 0;
        if (!(this.matrix.a[0] instanceof HFunction)) {
            throw new HThrowException(C.Error, C.List, new HString("not a matrix"));
        }
        n = ((HFunction)this.matrix.a[0]).len;
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.len][n];
        for (int i = 0; i < this.matrix.len; ++i) {
            if (!(this.matrix.a[i] instanceof HFunction)) {
                throw new HThrowException(C.Error, C.List, new HString("not a matrix"));
            }
            HFunction hFunction = (HFunction)this.matrix.a[i];
            if (n != hFunction.len) {
                throw new HThrowException(C.Error, C.List, new HString("different row lengths in matrix"));
            }
            for (int j = 0; j < n; ++j) {
                HObject hObject = C.NEV(hFunction.a[j]);
                if (hObject instanceof HDouble) {
                    hDoubleComplexArray[i][j] = new HDoubleComplex((HDouble)hObject);
                    continue;
                }
                if (hObject instanceof HDoubleComplex) {
                    hDoubleComplexArray[i][j] = (HDoubleComplex)hObject;
                    continue;
                }
                throw new HThrowException(C.Error, C.List, new HString("only numerical values allowed."));
            }
        }
        return hDoubleComplexArray;
    }

    public double[][] toDoubleMatrixArray() {
        if (this.matrix.len == 0) {
            throw new HThrowException(C.Error, C.List, new HString("size = 0"));
        }
        int n = 0;
        if (!(this.matrix.a[0] instanceof HFunction)) {
            throw new HThrowException(C.Error, C.List, new HString("not a matrix"));
        }
        n = ((HFunction)this.matrix.a[0]).len;
        double[][] dArray = new double[this.matrix.len][n];
        for (int i = 0; i < this.matrix.len; ++i) {
            if (!(this.matrix.a[i] instanceof HFunction)) {
                throw new HThrowException(C.Error, C.List, new HString("not a matrix"));
            }
            HFunction hFunction = (HFunction)this.matrix.a[i];
            if (n != hFunction.len) {
                throw new HThrowException(C.Error, C.List, new HString("different row lengths in matrix"));
            }
            for (int j = 0; j < n; ++j) {
                HObject hObject = C.NEV(hFunction.a[j]);
                if (!(hObject instanceof HDouble)) {
                    throw new HThrowException(C.Error, C.List, hObject);
                }
                dArray[i][j] = ((HDouble)hObject).value();
            }
        }
        return dArray;
    }
}

