/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.loadable;

import com.hartmath.expression.HComplex;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.loadable.EzMathOperator;
import com.hartmath.mapping.E1Arg;
import java.util.Hashtable;

public class EEzMath
extends E1Arg {
    public static Hashtable greekSym = new Hashtable(199);
    public static Hashtable operTab = new Hashtable(199);

    public static void convert(StringBuffer stringBuffer, HObject hObject) {
        int n = hObject.hierarchy();
        switch (n) {
            case 1: {
                EEzMath.convertDouble(stringBuffer, (HDouble)hObject);
                break;
            }
            case 2: {
                EEzMath.convertDoubleComplex(stringBuffer, (HDoubleComplex)hObject);
                break;
            }
            case 4: {
                EEzMath.convertInteger(stringBuffer, (HInteger)hObject);
                break;
            }
            case 8: {
                EEzMath.convertFraction(stringBuffer, (HFraction)hObject);
                break;
            }
            case 16: {
                EEzMath.convertComplex(stringBuffer, (HComplex)hObject);
                break;
            }
            case 32: {
                EEzMath.convertString(stringBuffer, (HString)hObject);
                break;
            }
            case 64: {
                EEzMath.convertSymbol(stringBuffer, (HSymbol)hObject);
                break;
            }
            case 256: {
                EEzMath.convertPattern(stringBuffer, (HPattern)hObject);
                break;
            }
            case 128: {
                HFunction hFunction = (HFunction)hObject;
                EzMathOperator ezMathOperator = (EzMathOperator)operTab.get(hFunction.head());
                if (ezMathOperator != null) {
                    ezMathOperator.convert(stringBuffer, hFunction);
                    break;
                }
                stringBuffer.append(" function ");
                EEzMath.convert(stringBuffer, hFunction.head());
                stringBuffer.append("(");
                for (int i = 0; i < hFunction.size(); ++i) {
                    EEzMath.convert(stringBuffer, hFunction.get(i));
                    if (i >= hFunction.size() - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                break;
            }
            default: {
                stringBuffer.append(hObject.toString());
            }
        }
    }

    public static void convertComplex(StringBuffer stringBuffer, HComplex hComplex) {
        stringBuffer.append("  complex(");
        stringBuffer.append(hComplex.re().toString());
        stringBuffer.append(",");
        stringBuffer.append(hComplex.im().toString());
        stringBuffer.append(")\n");
    }

    public static void convertDouble(StringBuffer stringBuffer, HDouble hDouble) {
        stringBuffer.append("{");
        stringBuffer.append(hDouble.toString());
        stringBuffer.append("}");
    }

    public static void convertDoubleComplex(StringBuffer stringBuffer, HDoubleComplex hDoubleComplex) {
        stringBuffer.append("  complex(");
        stringBuffer.append(String.valueOf(hDoubleComplex.real()));
        stringBuffer.append(",");
        stringBuffer.append(String.valueOf(hDoubleComplex.imag()));
        stringBuffer.append(")\n");
    }

    public static void convertFraction(StringBuffer stringBuffer, HFraction hFraction) {
        stringBuffer.append("{");
        stringBuffer.append(hFraction.numer().toString());
        stringBuffer.append("/");
        stringBuffer.append(hFraction.denom().toString());
        stringBuffer.append("}");
    }

    public static void convertInteger(StringBuffer stringBuffer, HInteger hInteger) {
        stringBuffer.append("{");
        stringBuffer.append(hInteger.toString());
        stringBuffer.append("}");
    }

    public static void convertPattern(StringBuffer stringBuffer, HPattern hPattern) {
        stringBuffer.append(hPattern.toString());
    }

    public static void convertString(StringBuffer stringBuffer, HString hString) {
        stringBuffer.append(" ");
        stringBuffer.append(hString.toString());
        stringBuffer.append(" ");
    }

    public static void convertSymbol(StringBuffer stringBuffer, HSymbol hSymbol) {
        stringBuffer.append(hSymbol.toString());
    }

    public HObject e1ObjArg(HObject hObject) {
        StringBuffer stringBuffer = new StringBuffer("  <embed type=\"text/ezmath\"\n  pluginspage=\"http://www.w3.org/People/Raggett/EzMath\"\n  align=absmiddle\n  width= 1024 height=100\n  color=\"#000000\"\n  bgcolor=\"silver\"\n  alt=\"");
        EEzMath.convert(stringBuffer, hObject);
        stringBuffer.append("\">\n");
        return new HString(stringBuffer);
    }

    public static int getPrecedence(HObject hObject) {
        int n = hObject.hierarchy();
        switch (n) {
            case 1: {
                return 1000;
            }
            case 2: {
                return 1000;
            }
            case 4: {
                return 1000;
            }
            case 8: {
                return 1000;
            }
            case 16: {
                return 1000;
            }
            case 32: {
                return 1000;
            }
            case 64: {
                return 1000;
            }
            case 256: {
                return 1000;
            }
            case 128: {
                HFunction hFunction = (HFunction)hObject;
                EzMathOperator ezMathOperator = (EzMathOperator)operTab.get(hFunction.head());
                if (ezMathOperator != null) {
                    return ezMathOperator.getPrecedence();
                }
                return 1000;
            }
        }
        return 1000;
    }

    static {
        operTab.put(C.Abs, new EzMathOperator("", "abs {", "}", -1, 1000));
        operTab.put(C.Sin, new EzMathOperator("", "sin {", "}", -1, 1000));
        operTab.put(C.Cos, new EzMathOperator("", "cos {", "}", -1, 1000));
        operTab.put(C.Tan, new EzMathOperator("", "tan {", "}", -1, 1000));
        operTab.put(C.Sinh, new EzMathOperator("", "sinh {", "}", -1, 1000));
        operTab.put(C.Cosh, new EzMathOperator("", "cosh {", "}", -1, 1000));
        operTab.put(C.Tanh, new EzMathOperator("", "tanh {", "}", -1, 1000));
        operTab.put(C.ASin, new EzMathOperator("", "arcsin {", "}", -1, 1000));
        operTab.put(C.ACos, new EzMathOperator("", "arccos {", "}", -1, 1000));
        operTab.put(C.ATan, new EzMathOperator("", "arctan {", "}", -1, 1000));
        operTab.put(C.Exp, new EzMathOperator("", "exp {", "}", -1, 1000));
        operTab.put(C.Factorial, new EzMathOperator("!", 780));
        operTab.put(C.Pow, new EzMathOperator("^", 760));
        operTab.put(C.Add, new EzMathOperator("+", 400));
        operTab.put(C.Multiply, new EzMathOperator("*", 480));
        operTab.put(C.Equal, new EzMathOperator(" equals ", 300));
        operTab.put(C.Unequal, new EzMathOperator("!=", 300));
        operTab.put(C.Less, new EzMathOperator("<", 300));
        operTab.put(C.Greater, new EzMathOperator(">", 300));
        operTab.put(C.LessEqual, new EzMathOperator("<=", 300));
        operTab.put(C.GreaterEqual, new EzMathOperator(">=", 300));
        greekSym.put("Alpha", C.True);
        greekSym.put("Beta", C.True);
        greekSym.put("Chi", C.True);
        greekSym.put("Delta", C.True);
        greekSym.put("Epsilon", C.True);
        greekSym.put("Phi", C.True);
        greekSym.put("Gamma", C.True);
        greekSym.put("Eta", C.True);
        greekSym.put("Iota", C.True);
        greekSym.put("varTheta", C.True);
        greekSym.put("Kappa", C.True);
        greekSym.put("Lambda", C.True);
        greekSym.put("Mu", C.True);
        greekSym.put("Nu", C.True);
        greekSym.put("Omicron", C.True);
        greekSym.put("Pi", C.True);
        greekSym.put("Theta", C.True);
        greekSym.put("Rho", C.True);
        greekSym.put("Sigma", C.True);
        greekSym.put("Tau", C.True);
        greekSym.put("Upsilon", C.True);
        greekSym.put("Omega", C.True);
        greekSym.put("Xi", C.True);
        greekSym.put("Psi", C.True);
        greekSym.put("Zeta", C.True);
        greekSym.put("alpha", C.True);
        greekSym.put("beta", C.True);
        greekSym.put("chi", C.True);
        greekSym.put("selta", C.True);
        greekSym.put("epsilon", C.True);
        greekSym.put("phi", C.True);
        greekSym.put("gamma", C.True);
        greekSym.put("eta", C.True);
        greekSym.put("iota", C.True);
        greekSym.put("varphi", C.True);
        greekSym.put("kappa", C.True);
        greekSym.put("lambda", C.True);
        greekSym.put("mu", C.True);
        greekSym.put("nu", C.True);
        greekSym.put("omicron", C.True);
        greekSym.put("pi", C.True);
        greekSym.put("theta", C.True);
        greekSym.put("rho", C.True);
        greekSym.put("sigma", C.True);
        greekSym.put("tau", C.True);
        greekSym.put("upsilon", C.True);
        greekSym.put("varomega", C.True);
        greekSym.put("omega", C.True);
        greekSym.put("xi", C.True);
        greekSym.put("psi", C.True);
        greekSym.put("zeta", C.True);
    }
}

