/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.patternmatching;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.mapping.FunctionEvaluator;
import com.hartmath.patternmatching.HRuleSet;

public class ERuleEvaluator
implements FunctionEvaluator {
    int len;
    HRuleSet rset;

    public ERuleEvaluator(int n) {
        this.len = n;
        this.rset = null;
    }

    public HObject evaluate(HFunction hFunction) {
        if (hFunction.size() < this.len) {
            return null;
        }
        if (hFunction.size() > this.len) {
            for (int i = this.len; i < hFunction.size(); ++i) {
                if (!(hFunction.get(i) instanceof HFunction)) {
                    return null;
                }
                HFunction hFunction2 = (HFunction)hFunction.get(i);
                if (hFunction2.size() != 2 || hFunction2.head() != C.Rule && hFunction2.head() != C.RuleDelayed) continue;
                this.rset = new HRuleSet(hFunction2.get(0).head());
                if (hFunction2.head() == C.Rule) {
                    this.rset.putDownRule(1, hFunction2.get(0), hFunction2.get(1));
                    continue;
                }
                this.rset.putDownRule(2, hFunction2.get(0), hFunction2.get(1));
            }
        }
        return this.evaluateOptions(new HFunction(hFunction, hFunction.head(), 0, this.len, true));
    }

    public HObject evaluateOptions(HFunction hFunction) {
        return null;
    }

    public int getIntOption(HSymbol hSymbol, HInteger hInteger) {
        HObject hObject;
        if (this.rset != null && (hObject = this.rset.getDownRule(hSymbol)) != null && (hObject instanceof HInteger || hObject instanceof HDouble)) {
            if (hObject instanceof HInteger) {
                return ((HInteger)hObject).intValue();
            }
            return ((HDouble)hObject).intValue();
        }
        return hInteger.intValue();
    }

    public HObject getOption(HSymbol hSymbol, HObject hObject) {
        HObject hObject2 = this.rset.getDownRule(hSymbol);
        return hObject2 == null ? hObject : hObject2;
    }
}

