/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexMatrix;
import com.hartmath.util.ComplexSquareMatrix;
import com.hartmath.util.ComplexTridiagonalMatrix;
import com.hartmath.util.ComplexVector;
import com.hartmath.util.DimensionException;
import com.hartmath.util.DoubleDiagonalMatrix;
import com.hartmath.util.DoubleMatrix;
import com.hartmath.util.Matrix;
import com.hartmath.util.MatrixDimensionException;

public final class ComplexDiagonalMatrix
extends ComplexTridiagonalMatrix {
    protected ComplexDiagonalMatrix() {
    }

    public ComplexDiagonalMatrix(HDoubleComplex[][] hDoubleComplexArray) {
        this(hDoubleComplexArray.length);
        if (hDoubleComplexArray.length == hDoubleComplexArray[0].length) {
            for (int i = 0; i < this.matrix[0].length; ++i) {
                this.matrix[0][i] = hDoubleComplexArray[i][i];
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("Array must be square.");
        }
    }

    public ComplexDiagonalMatrix(HDoubleComplex[] hDoubleComplexArray) {
        this();
        this.matrix = new HDoubleComplex[1][];
        this.matrix[0] = hDoubleComplexArray;
    }

    public ComplexDiagonalMatrix(int n) {
        this();
        this.matrix = new HDoubleComplex[1][n];
    }

    public ComplexDiagonalMatrix add(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.matrix[0].length == complexDiagonalMatrix.rows()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
            hDoubleComplexArray[0] = this.matrix[0][0].add(complexDiagonalMatrix.getElement(0, 0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.matrix[0][i].add(complexDiagonalMatrix.getElement(i, i));
            }
            return new ComplexDiagonalMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexDiagonalMatrix) {
            return this.add((ComplexDiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawAdd((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawAdd((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawAdd(complexMatrix);
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.add((ComplexDiagonalMatrix)complexSquareMatrix);
        }
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawAdd((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawAdd(complexSquareMatrix);
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (complexTridiagonalMatrix instanceof ComplexDiagonalMatrix) {
            return this.add((ComplexDiagonalMatrix)complexTridiagonalMatrix);
        }
        return this.rawAdd(complexTridiagonalMatrix);
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof ComplexDiagonalMatrix) {
            return this.add((ComplexDiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.rawAdd((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawAdd((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawAdd((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public ComplexMatrix conjugate() {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
        hDoubleComplexArray[0] = this.matrix[0][0].conj();
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = this.matrix[0][i].conj();
        }
        return new ComplexDiagonalMatrix(hDoubleComplexArray);
    }

    public HDoubleComplex det() {
        HDoubleComplex hDoubleComplex = this.matrix[0][0];
        for (int i = 1; i < this.matrix[0].length; ++i) {
            hDoubleComplex = hDoubleComplex.multiply(this.matrix[0][i]);
        }
        return hDoubleComplex;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexDiagonalMatrix && this.matrix[0].length == ((ComplexDiagonalMatrix)object).rows()) {
            ComplexDiagonalMatrix complexDiagonalMatrix = (ComplexDiagonalMatrix)object;
            for (int i = 0; i < this.matrix[0].length; ++i) {
                if (this.matrix[0][i].equals(complexDiagonalMatrix.getElement(i, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public double frobeniusNorm() {
        double d = this.matrix[0][0].mod() * this.matrix[0][0].mod();
        for (int i = 1; i < this.matrix[0].length; ++i) {
            d += this.matrix[0][i].mod() * this.matrix[0][i].mod();
        }
        return Math.sqrt(d);
    }

    public HDoubleComplex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length) {
            if (n == n2) {
                return this.matrix[0][n];
            }
            return HDoubleComplex.DC0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public static ComplexDiagonalMatrix identity(int n) {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[n];
        for (int i = 0; i < n; ++i) {
            hDoubleComplexArray[i] = HDoubleComplex.DC1;
        }
        return new ComplexDiagonalMatrix(hDoubleComplexArray);
    }

    public DoubleMatrix imag() {
        double[] dArray = new double[this.matrix[0].length];
        for (int i = 0; i < this.matrix[0].length; ++i) {
            dArray[i] = this.matrix[0][i].imag();
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public double infNorm() {
        double d = this.matrix[0][0].mod();
        for (int i = 1; i < this.matrix[0].length; ++i) {
            double d2 = this.matrix[0][i].mod();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public ComplexSquareMatrix inverse() {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
        hDoubleComplexArray[0] = HDoubleComplex.DC1.divide(this.matrix[0][0]);
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = HDoubleComplex.DC1.divide(this.matrix[0][i]);
        }
        return new ComplexDiagonalMatrix(hDoubleComplexArray);
    }

    public boolean isHermitian() {
        return this.equals(this.conjugate());
    }

    public boolean isUnitary() {
        return this.multiply(this.conjugate()).equals(ComplexDiagonalMatrix.identity(this.matrix[0].length));
    }

    public ComplexSquareMatrix[] luDecompose() {
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexDiagonalMatrix[]{ComplexDiagonalMatrix.identity(this.matrix[0].length), this};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
        hDoubleComplexArray[0] = hUnaryNumerical.map(this.matrix[0][0]);
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = hUnaryNumerical.map(this.matrix[0][i]);
        }
        return new ComplexDiagonalMatrix(hDoubleComplexArray);
    }

    public ComplexDiagonalMatrix multiply(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.matrix[0].length == complexDiagonalMatrix.rows()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
            hDoubleComplexArray[0] = this.matrix[0][0].multiply(complexDiagonalMatrix.getElement(0, 0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.matrix[0][i].multiply(complexDiagonalMatrix.getElement(i, i));
            }
            return new ComplexDiagonalMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawMultiply((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawMultiply((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawMultiply(complexMatrix);
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)complexSquareMatrix);
        }
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawMultiply((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawMultiply(complexSquareMatrix);
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (complexTridiagonalMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)complexTridiagonalMatrix);
        }
        return this.rawMultiply(complexTridiagonalMatrix);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrix[0].length == complexVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
            hDoubleComplexArray[0] = this.matrix[0][0].multiply(complexVector.getComponent(0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.matrix[0][i].multiply(complexVector.getComponent(i));
            }
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.rawMultiply((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawMultiply((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawMultiply((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    private ComplexMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            int n;
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = complexMatrix.getElement(i, 0);
                for (n = 1; n < hDoubleComplexArray.length; ++n) {
                    hDoubleComplexArray[i][n] = complexMatrix.getElement(i, n);
                }
            }
            for (n = 0; n < hDoubleComplexArray.length; ++n) {
                hDoubleComplexArray[n][n] = hDoubleComplexArray[n][n].add(this.matrix[0][n]);
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[0].length == complexSquareMatrix.rows()) {
            int n;
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = complexSquareMatrix.getElement(i, 0);
                for (n = 1; n < hDoubleComplexArray.length; ++n) {
                    hDoubleComplexArray[i][n] = complexSquareMatrix.getElement(i, n);
                }
            }
            for (n = 0; n < hDoubleComplexArray.length; ++n) {
                hDoubleComplexArray[n][n] = hDoubleComplexArray[n][n].add(this.matrix[0][n]);
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix rawAdd(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (this.matrix[0].length == complexTridiagonalMatrix.rows()) {
            int n = this.matrix[0].length;
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0].add(complexTridiagonalMatrix.getElement(0, 0)));
            complexTridiagonalMatrix2.setElement(1, 0, complexTridiagonalMatrix.getElement(1, 0));
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.setElement(i - 1, i, complexTridiagonalMatrix.getElement(i - 1, i));
                complexTridiagonalMatrix2.setElement(i, i, this.matrix[0][i].add(complexTridiagonalMatrix.getElement(i, i)));
                complexTridiagonalMatrix2.setElement(i + 1, i, complexTridiagonalMatrix.getElement(i + 1, i));
            }
            complexTridiagonalMatrix2.setElement(n - 1, n, complexTridiagonalMatrix.getElement(n - 1, n));
            complexTridiagonalMatrix2.setElement(n, n, this.matrix[0][n].add(complexTridiagonalMatrix.getElement(n, n)));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][complexMatrix.columns()];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[0][i].multiply(complexMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[0][i].multiply(complexMatrix.getElement(i, j));
                }
            }
            return new ComplexMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[0].length == complexSquareMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[0][i].multiply(complexSquareMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[0][i].multiply(complexSquareMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[0].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0].multiply(complexTridiagonalMatrix.getElement(0, 0)));
            complexTridiagonalMatrix2.setElement(0, 1, this.matrix[0][0].multiply(complexTridiagonalMatrix.getElement(0, 1)));
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.setElement(i, i - 1, this.matrix[0][i].multiply(complexTridiagonalMatrix.getElement(i, i - 1)));
                complexTridiagonalMatrix2.setElement(i, i, this.matrix[0][i].multiply(complexTridiagonalMatrix.getElement(i, i)));
                complexTridiagonalMatrix2.setElement(i, i + 1, this.matrix[0][i].multiply(complexTridiagonalMatrix.getElement(i, i + 1)));
            }
            complexTridiagonalMatrix2.setElement(n, n - 1, this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n, n - 1)));
            complexTridiagonalMatrix2.setElement(n, n, this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n, n)));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            int n;
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = complexMatrix.getElement(i, 0).negate();
                for (n = 1; n < hDoubleComplexArray.length; ++n) {
                    hDoubleComplexArray[i][n] = complexMatrix.getElement(i, n).negate();
                }
            }
            for (n = 0; n < hDoubleComplexArray.length; ++n) {
                hDoubleComplexArray[n][n] = hDoubleComplexArray[n][n].add(this.matrix[0][n]);
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawSubtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[0].length == complexSquareMatrix.rows()) {
            int n;
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = complexSquareMatrix.getElement(i, 0).negate();
                for (n = 1; n < hDoubleComplexArray.length; ++n) {
                    hDoubleComplexArray[i][n] = complexSquareMatrix.getElement(i, n).negate();
                }
            }
            for (n = 0; n < hDoubleComplexArray.length; ++n) {
                hDoubleComplexArray[n][n] = hDoubleComplexArray[n][n].add(this.matrix[0][n]);
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix rawSubtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (this.matrix[0].length == complexTridiagonalMatrix.rows()) {
            int n = this.matrix[0].length;
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0].subtract(complexTridiagonalMatrix.getElement(0, 0)));
            complexTridiagonalMatrix2.setElement(1, 0, complexTridiagonalMatrix.getElement(1, 0).negate());
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.setElement(i - 1, i, complexTridiagonalMatrix.getElement(i - 1, i).negate());
                complexTridiagonalMatrix2.setElement(i, i, this.matrix[0][i].subtract(complexTridiagonalMatrix.getElement(i, i)));
                complexTridiagonalMatrix2.setElement(i + 1, i, complexTridiagonalMatrix.getElement(i + 1, i).negate());
            }
            complexTridiagonalMatrix2.setElement(n - 1, n, complexTridiagonalMatrix.getElement(n - 1, n).negate());
            complexTridiagonalMatrix2.setElement(n, n, this.matrix[0][n].subtract(complexTridiagonalMatrix.getElement(n, n)));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix real() {
        double[] dArray = new double[this.matrix[0].length];
        for (int i = 0; i < this.matrix[0].length; ++i) {
            dArray[i] = this.matrix[0][i].real();
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public int rows() {
        return this.matrix[0].length;
    }

    public ComplexMatrix scalarMultiply(double d) {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
        hDoubleComplexArray[0] = this.matrix[0][0].multiply(d);
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = this.matrix[0][i].multiply(d);
        }
        return new ComplexDiagonalMatrix(hDoubleComplexArray);
    }

    public ComplexMatrix scalarMultiply(HDoubleComplex hDoubleComplex) {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
        hDoubleComplexArray[0] = hDoubleComplex.multiply(this.matrix[0][0]);
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = hDoubleComplex.multiply(this.matrix[0][i]);
        }
        return new ComplexDiagonalMatrix(hDoubleComplexArray);
    }

    public void setElement(int n, int n2, HDoubleComplex hDoubleComplex) {
        if (n < 0 || n >= this.matrix[0].length || n2 < 0 || n2 >= this.matrix[0].length || n != n2) {
            throw new MatrixDimensionException("Invalid element.");
        }
        this.matrix[0][n] = hDoubleComplex;
    }

    public ComplexDiagonalMatrix subtract(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.matrix[0].length == complexDiagonalMatrix.rows()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
            hDoubleComplexArray[0] = this.matrix[0][0].subtract(complexDiagonalMatrix.getElement(0, 0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.matrix[0][i].subtract(complexDiagonalMatrix.getElement(i, i));
            }
            return new ComplexDiagonalMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawSubtract((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawSubtract((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawSubtract(complexMatrix);
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)complexSquareMatrix);
        }
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawSubtract((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawSubtract(complexSquareMatrix);
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (complexTridiagonalMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)complexTridiagonalMatrix);
        }
        return this.rawSubtract(complexTridiagonalMatrix);
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.rawSubtract((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawSubtract((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawSubtract((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public HDoubleComplex trace() {
        HDoubleComplex hDoubleComplex = this.matrix[0][0];
        for (int i = 1; i < this.matrix[0].length; ++i) {
            hDoubleComplex = hDoubleComplex.add(this.matrix[0][i]);
        }
        return hDoubleComplex;
    }

    public Matrix transpose() {
        return this;
    }
}

