/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexMatrix;
import com.hartmath.util.ComplexSquareMatrix;
import com.hartmath.util.ComplexVector;
import com.hartmath.util.DimensionException;
import com.hartmath.util.DoubleMatrix;
import com.hartmath.util.DoubleTridiagonalMatrix;
import com.hartmath.util.Matrix;
import com.hartmath.util.MatrixDimensionException;

public class ComplexTridiagonalMatrix
extends ComplexSquareMatrix {
    protected ComplexTridiagonalMatrix() {
    }

    public ComplexTridiagonalMatrix(HDoubleComplex[][] hDoubleComplexArray) {
        this(hDoubleComplexArray.length);
        int n;
        if (hDoubleComplexArray.length == hDoubleComplexArray[0].length) {
            this.matrix[1][0] = hDoubleComplexArray[0][0];
            this.matrix[2][0] = hDoubleComplexArray[0][1];
            for (n = 1; n < hDoubleComplexArray.length - 1; ++n) {
                this.matrix[0][n] = hDoubleComplexArray[n][n - 1];
                this.matrix[1][n] = hDoubleComplexArray[n][n];
                this.matrix[2][n] = hDoubleComplexArray[n][n + 1];
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
        this.matrix[0][n] = hDoubleComplexArray[n][n - 1];
        this.matrix[1][n] = hDoubleComplexArray[n][n];
    }

    public ComplexTridiagonalMatrix(int n) {
        this();
        this.matrix = new HDoubleComplex[3][n];
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawAdd((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawAdd(complexMatrix);
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawAdd(complexSquareMatrix);
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0].add(complexTridiagonalMatrix.getElement(0, 0));
            complexTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0].add(complexTridiagonalMatrix.getElement(0, 1));
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.matrix[0][i] = this.matrix[0][i].add(complexTridiagonalMatrix.getElement(i, i - 1));
                complexTridiagonalMatrix2.matrix[1][i] = this.matrix[1][i].add(complexTridiagonalMatrix.getElement(i, i));
                complexTridiagonalMatrix2.matrix[2][i] = this.matrix[2][i].add(complexTridiagonalMatrix.getElement(i, i + 1));
            }
            complexTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n].add(complexTridiagonalMatrix.getElement(n, n - 1));
            complexTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n].add(complexTridiagonalMatrix.getElement(n, n));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawAdd((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawAdd((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public int columns() {
        return this.matrix[1].length;
    }

    public ComplexMatrix conjugate() {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].conj();
        complexTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].conj();
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.matrix[0][i] = this.matrix[0][i].conj();
            complexTridiagonalMatrix.matrix[1][i] = this.matrix[1][i].conj();
            complexTridiagonalMatrix.matrix[2][i] = this.matrix[2][i].conj();
        }
        complexTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].conj();
        complexTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].conj();
        return complexTridiagonalMatrix;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexTridiagonalMatrix && this.matrix[1].length == ((ComplexTridiagonalMatrix)object).rows()) {
            int n;
            ComplexTridiagonalMatrix complexTridiagonalMatrix = (ComplexTridiagonalMatrix)object;
            if (!this.matrix[1][0].equals(complexTridiagonalMatrix.getElement(0, 0))) {
                return false;
            }
            if (!this.matrix[2][0].equals(complexTridiagonalMatrix.getElement(0, 1))) {
                return false;
            }
            for (n = 1; n < this.matrix[1].length - 1; ++n) {
                if (!this.matrix[0][n].equals(complexTridiagonalMatrix.getElement(n, n - 1))) {
                    return false;
                }
                if (!this.matrix[1][n].equals(complexTridiagonalMatrix.getElement(n, n))) {
                    return false;
                }
                if (this.matrix[2][n].equals(complexTridiagonalMatrix.getElement(n, n + 1))) continue;
                return false;
            }
            if (!this.matrix[0][n].equals(complexTridiagonalMatrix.getElement(n, n - 1))) {
                return false;
            }
            return this.matrix[1][n].equals(complexTridiagonalMatrix.getElement(n, n));
        }
        return false;
    }

    public double frobeniusNorm() {
        int n;
        double d = this.matrix[1][0].mod() * this.matrix[1][0].mod() + this.matrix[2][0].mod() * this.matrix[2][0].mod();
        for (n = 1; n < this.matrix[1].length - 1; ++n) {
            d += this.matrix[0][n].mod() * this.matrix[0][n].mod() + this.matrix[1][n].mod() * this.matrix[1][n].mod() + this.matrix[2][n].mod() * this.matrix[2][n].mod();
        }
        return Math.sqrt(d += this.matrix[0][n].mod() * this.matrix[0][n].mod() + this.matrix[1][n].mod() * this.matrix[1][n].mod());
    }

    public HDoubleComplex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                return this.matrix[0][n];
            }
            if (n2 == n) {
                return this.matrix[1][n];
            }
            if (n2 == n + 1) {
                return this.matrix[2][n];
            }
            return HDoubleComplex.DC0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public ComplexMatrix hermitianAdjoint() {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].conj();
        complexTridiagonalMatrix.setElement(1, 0, this.matrix[2][0].conj());
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.setElement(i - 1, i, this.matrix[0][i].conj());
            complexTridiagonalMatrix.matrix[1][i] = this.matrix[1][i].conj();
            complexTridiagonalMatrix.setElement(i + 1, i, this.matrix[2][i].conj());
        }
        complexTridiagonalMatrix.setElement(n - 1, n, this.matrix[0][n].conj());
        complexTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].conj();
        return complexTridiagonalMatrix;
    }

    public DoubleMatrix imag() {
        int n;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrix[1].length);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].imag();
        doubleTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].imag();
        for (n = 1; n < this.matrix[1].length - 1; ++n) {
            doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].imag();
            doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].imag();
            doubleTridiagonalMatrix.matrix[2][n] = this.matrix[2][n].imag();
        }
        doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].imag();
        doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].imag();
        return doubleTridiagonalMatrix;
    }

    public double infNorm() {
        double d;
        int n;
        double d2 = this.matrix[1][0].mod() + this.matrix[2][0].mod();
        for (n = 1; n < this.matrix[1].length - 1; ++n) {
            d = this.matrix[0][n].mod() + this.matrix[1][n].mod() + this.matrix[2][n].mod();
            if (!(d > d2)) continue;
            d2 = d;
        }
        d = this.matrix[0][n].mod() + this.matrix[1][n].mod();
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public ComplexSquareMatrix[] luDecompose() {
        int n;
        HDoubleComplex[][][] hDoubleComplexArray = new HDoubleComplex[2][this.matrix[1].length][this.matrix[1].length];
        hDoubleComplexArray[0][0][0] = HDoubleComplex.DC1;
        for (n = 1; n < this.matrix[1].length; ++n) {
            hDoubleComplexArray[0][n][n] = HDoubleComplex.DC1;
        }
        for (int i = 0; i < this.matrix[1].length; ++i) {
            int n2;
            HDoubleComplex hDoubleComplex;
            for (n = 0; n <= i; ++n) {
                hDoubleComplex = this.getElement(n, i);
                for (n2 = 0; n2 < n; ++n2) {
                    hDoubleComplex = hDoubleComplex.subtract(hDoubleComplexArray[0][n][n2].multiply(hDoubleComplexArray[1][n2][i]));
                }
                hDoubleComplexArray[1][n][i] = hDoubleComplex;
            }
            for (n = i + 1; n < this.matrix[1].length; ++n) {
                hDoubleComplex = this.getElement(n, i);
                for (n2 = 0; n2 < i; ++n2) {
                    hDoubleComplex = hDoubleComplex.subtract(hDoubleComplexArray[0][n][n2].multiply(hDoubleComplexArray[1][n2][i]));
                }
                hDoubleComplexArray[0][n][i] = hDoubleComplex.divide(hDoubleComplexArray[1][i][i]);
            }
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(hDoubleComplexArray[0]), new ComplexSquareMatrix(hDoubleComplexArray[1])};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = hUnaryNumerical.map(this.matrix[1][0]);
        complexTridiagonalMatrix.matrix[2][0] = hUnaryNumerical.map(this.matrix[2][0]);
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.matrix[0][i] = hUnaryNumerical.map(this.matrix[0][i]);
            complexTridiagonalMatrix.matrix[1][i] = hUnaryNumerical.map(this.matrix[1][i]);
            complexTridiagonalMatrix.matrix[2][i] = hUnaryNumerical.map(this.matrix[2][i]);
        }
        complexTridiagonalMatrix.matrix[0][n] = hUnaryNumerical.map(this.matrix[0][n]);
        complexTridiagonalMatrix.matrix[1][n] = hUnaryNumerical.map(this.matrix[1][n]);
        return complexTridiagonalMatrix;
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawMultiply((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawMultiply(complexMatrix);
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawMultiply(complexSquareMatrix);
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[n][n];
            hDoubleComplexArray[0][0] = this.matrix[1][0].multiply(complexTridiagonalMatrix.getElement(0, 0)).add(this.matrix[2][0].multiply(complexTridiagonalMatrix.getElement(1, 0)));
            hDoubleComplexArray[0][1] = this.matrix[1][0].multiply(complexTridiagonalMatrix.getElement(0, 1)).add(this.matrix[2][0].multiply(complexTridiagonalMatrix.getElement(1, 1)));
            hDoubleComplexArray[0][2] = this.matrix[2][0].multiply(complexTridiagonalMatrix.getElement(1, 2));
            if (n > 3) {
                hDoubleComplexArray[1][0] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 0)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 0)));
                hDoubleComplexArray[1][1] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 1)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 1))).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 1)));
                hDoubleComplexArray[1][2] = this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 2)).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 2)));
                hDoubleComplexArray[1][3] = this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 3));
            }
            if (n == 3) {
                hDoubleComplexArray[1][0] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 0)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 0)));
                hDoubleComplexArray[1][1] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 1)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 1))).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 1)));
                hDoubleComplexArray[1][2] = this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 2)).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 2)));
            } else if (n > 4) {
                for (int i = 2; i < n - 2; ++i) {
                    hDoubleComplexArray[i][i - 2] = this.matrix[0][i].multiply(complexTridiagonalMatrix.getElement(i - 1, i - 2));
                    hDoubleComplexArray[i][i - 1] = this.matrix[0][i].multiply(complexTridiagonalMatrix.getElement(i - 1, i - 1)).add(this.matrix[1][i].multiply(complexTridiagonalMatrix.getElement(i, i - 1)));
                    hDoubleComplexArray[i][i] = this.matrix[0][i].multiply(complexTridiagonalMatrix.getElement(i - 1, i)).add(this.matrix[1][i].multiply(complexTridiagonalMatrix.getElement(i, i))).add(this.matrix[2][i].multiply(complexTridiagonalMatrix.getElement(i + 1, i)));
                    hDoubleComplexArray[i][i + 1] = this.matrix[1][i].multiply(complexTridiagonalMatrix.getElement(i, i + 1)).add(this.matrix[2][i].multiply(complexTridiagonalMatrix.getElement(i + 1, i + 1)));
                    hDoubleComplexArray[i][i + 2] = this.matrix[2][i].multiply(complexTridiagonalMatrix.getElement(i + 1, i + 2));
                }
            }
            if (n > 3) {
                hDoubleComplexArray[n - 2][n - 4] = this.matrix[0][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 3, n - 4));
                hDoubleComplexArray[n - 2][n - 3] = this.matrix[0][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 3, n - 3)).add(this.matrix[1][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 2, n - 3)));
                hDoubleComplexArray[n - 2][n - 2] = this.matrix[0][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 3, n - 2)).add(this.matrix[1][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 2, n - 2))).add(this.matrix[2][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 2)));
                hDoubleComplexArray[n - 2][n - 1] = this.matrix[1][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 2, n - 1)).add(this.matrix[2][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 1)));
            }
            hDoubleComplexArray[n][--n - 2] = this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 2));
            hDoubleComplexArray[n][n - 1] = this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 1)).add(this.matrix[1][n].multiply(complexTridiagonalMatrix.getElement(n, n - 1)));
            hDoubleComplexArray[n][n] = this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n - 1, n)).add(this.matrix[1][n].multiply(complexTridiagonalMatrix.getElement(n, n)));
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        int n = this.matrix[1].length;
        if (n == complexVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[n];
            hDoubleComplexArray[0] = this.matrix[1][0].multiply(complexVector.getComponent(0)).add(this.matrix[2][0].multiply(complexVector.getComponent(1)));
            --n;
            for (int i = 1; i < n; ++i) {
                hDoubleComplexArray[i] = this.matrix[0][i].multiply(complexVector.getComponent(i - 1)).add(this.matrix[1][i].multiply(complexVector.getComponent(i))).add(this.matrix[2][i].multiply(complexVector.getComponent(i + 1)));
            }
            hDoubleComplexArray[n] = this.matrix[0][n].multiply(complexVector.getComponent(n - 1)).add(this.matrix[1][n].multiply(complexVector.getComponent(n)));
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawMultiply((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawMultiply((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    private ComplexMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrix[1].length == complexMatrix.rows() && this.matrix[1].length == complexMatrix.columns()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.getElement(i, 0).add(complexMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.getElement(i, j).add(complexMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[1].length == complexSquareMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.getElement(i, 0).add(complexSquareMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.getElement(i, j).add(complexSquareMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrix[1].length == complexMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[1].length][complexMatrix.columns()];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                for (int j = 0; j < hDoubleComplexArray[0].length; ++j) {
                    hDoubleComplexArray[i][j] = this.getElement(i, 0).multiply(complexMatrix.getElement(0, j));
                    for (int k = 1; k < this.matrix[1].length; ++k) {
                        hDoubleComplexArray[i][j] = hDoubleComplexArray[i][j].add(this.getElement(i, k).multiply(complexMatrix.getElement(k, j)));
                    }
                }
            }
            return new ComplexMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[1].length == complexSquareMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                for (int j = 0; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.getElement(i, 0).multiply(complexSquareMatrix.getElement(0, j));
                    for (int k = 1; k < hDoubleComplexArray.length; ++k) {
                        hDoubleComplexArray[i][j] = hDoubleComplexArray[i][j].add(this.getElement(i, k).multiply(complexSquareMatrix.getElement(k, j)));
                    }
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrix[1].length == complexMatrix.rows() && this.matrix[1].length == complexMatrix.columns()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.getElement(i, 0).subtract(complexMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.getElement(i, j).subtract(complexMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawSubtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[1].length == complexSquareMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[1].length][this.matrix[1].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.getElement(i, 0).subtract(complexSquareMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.getElement(i, j).subtract(complexSquareMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix real() {
        int n;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrix[1].length);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].real();
        doubleTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].real();
        for (n = 1; n < this.matrix[1].length - 1; ++n) {
            doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].real();
            doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].real();
            doubleTridiagonalMatrix.matrix[2][n] = this.matrix[2][n].real();
        }
        doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].real();
        doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].real();
        return doubleTridiagonalMatrix;
    }

    public int rows() {
        return this.matrix[1].length;
    }

    public ComplexMatrix scalarMultiply(double d) {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].multiply(d);
        complexTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].multiply(d);
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.matrix[0][i] = this.matrix[0][i].multiply(d);
            complexTridiagonalMatrix.matrix[1][i] = this.matrix[1][i].multiply(d);
            complexTridiagonalMatrix.matrix[2][i] = this.matrix[2][i].multiply(d);
        }
        complexTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].multiply(d);
        complexTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].multiply(d);
        return complexTridiagonalMatrix;
    }

    public ComplexMatrix scalarMultiply(HDoubleComplex hDoubleComplex) {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = hDoubleComplex.multiply(this.matrix[1][0]);
        complexTridiagonalMatrix.matrix[2][0] = hDoubleComplex.multiply(this.matrix[2][0]);
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.matrix[0][i] = hDoubleComplex.multiply(this.matrix[0][i]);
            complexTridiagonalMatrix.matrix[1][i] = hDoubleComplex.multiply(this.matrix[1][i]);
            complexTridiagonalMatrix.matrix[2][i] = hDoubleComplex.multiply(this.matrix[2][i]);
        }
        complexTridiagonalMatrix.matrix[0][n] = hDoubleComplex.multiply(this.matrix[0][n]);
        complexTridiagonalMatrix.matrix[1][n] = hDoubleComplex.multiply(this.matrix[1][n]);
        return complexTridiagonalMatrix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, HDoubleComplex hDoubleComplex) {
        if (n < 0 || n >= this.matrix[1].length || n2 < 0 || n2 >= this.matrix[1].length) throw new MatrixDimensionException("Invalid element.");
        if (n2 == n - 1) {
            this.matrix[0][n] = hDoubleComplex;
            return;
        } else if (n2 == n) {
            this.matrix[1][n] = hDoubleComplex;
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException("Invalid element.");
            this.matrix[2][n] = hDoubleComplex;
        }
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawSubtract((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawSubtract(complexMatrix);
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawSubtract(complexSquareMatrix);
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0].subtract(complexTridiagonalMatrix.getElement(0, 0));
            complexTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0].subtract(complexTridiagonalMatrix.getElement(0, 1));
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.matrix[0][i] = this.matrix[0][i].subtract(complexTridiagonalMatrix.getElement(i, i - 1));
                complexTridiagonalMatrix2.matrix[1][i] = this.matrix[1][i].subtract(complexTridiagonalMatrix.getElement(i, i));
                complexTridiagonalMatrix2.matrix[2][i] = this.matrix[2][i].subtract(complexTridiagonalMatrix.getElement(i, i + 1));
            }
            complexTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n].subtract(complexTridiagonalMatrix.getElement(n, n - 1));
            complexTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n].subtract(complexTridiagonalMatrix.getElement(n, n));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawSubtract((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawSubtract((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[1].length);
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                stringBuffer.append(this.getElement(i, j).toString());
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public HDoubleComplex trace() {
        HDoubleComplex hDoubleComplex = this.matrix[1][0];
        for (int i = 1; i < this.matrix[1].length; ++i) {
            hDoubleComplex = hDoubleComplex.add(this.matrix[1][i]);
        }
        return hDoubleComplex;
    }

    public Matrix transpose() {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = this.matrix[1][0];
        complexTridiagonalMatrix.setElement(1, 0, this.matrix[2][0]);
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.setElement(i - 1, i, this.matrix[0][i]);
            complexTridiagonalMatrix.matrix[1][i] = this.matrix[1][i];
            complexTridiagonalMatrix.setElement(i + 1, i, this.matrix[2][i]);
        }
        complexTridiagonalMatrix.setElement(n - 1, n, this.matrix[0][n]);
        complexTridiagonalMatrix.matrix[1][n] = this.matrix[1][n];
        return complexTridiagonalMatrix;
    }
}

