/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Coordinates;
import geonext.Element;
import geonext.Geonext;
import geonext.Graph;
import geonext.JBoardPane;
import geonext.Slider;
import java.awt.Color;
import java.awt.Graphics2D;

class GraphSlider
extends Slider {
    Coordinates historicUser;
    public boolean free = false;
    public boolean animated;
    public double position = 0.0;
    public boolean direction = false;
    public int loop = 1;
    public double start = 0.0;
    public double stop = 1.0;
    public double speed = 1.0;
    public boolean back = false;

    public boolean exists() {
        return this.e.exists() && this.isActive();
    }

    public void setPosition(Coordinates coordinates) {
        this.setUser(coordinates);
    }

    public GraphSlider() {
        this.initGraphSlider();
    }

    public GraphSlider(String string, int n, Element element, int n2) {
        super(string, n, element, n2);
        this.initGraphSlider();
        this.historicUser = new Coordinates();
        this.setAnimated(false);
        this.setSpeed(0.1);
        this.setStart(-4.0);
        this.setStop(3.0);
    }

    public void calculate(JBoardPane jBoardPane, boolean bl) {
        this.setStart(jBoardPane.TLPoint.getUserX());
        this.setStop(jBoardPane.TRPoint.getUserX());
        this.calculateChanged(bl);
        if (this.isChanged()) {
            this.setActive(true);
            if (!this.isComposition()) {
                try {
                    this.setUser();
                }
                catch (Exception exception) {
                    if (!this.isAnimated()) {
                        this.recall();
                    }
                    this.setActive(false);
                }
                this.user2sphere();
                jBoardPane.user2screen(this);
                boolean bl2 = false;
                if (this.getScreenY() < 0.0 | this.getScreenY() > (double)jBoardPane.getHeight() && this.getHistoricUser().getWidth() != jBoardPane.screen2userX(this.getScreenX())) {
                    if (jBoardPane.motion == null || jBoardPane.motion != null && !this.isAnimated()) {
                        this.recall();
                        this.user2sphere();
                        jBoardPane.user2screen(this);
                    }
                } else {
                    this.storeUser();
                }
            }
        }
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("graphslider_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        super.draw(graphics2D, jBoardPane);
    }

    public Coordinates getHistoricUser() {
        return this.historicUser;
    }

    public void initGraphSlider() {
        this.stroke = new Color(255, 150, 0);
        this.lighting = Color.green;
        this.label = Color.black;
        this.typeString = "slider";
        this.setElementName(Geonext.language.getString("graphslider_element_name"));
    }

    public void recall() {
        this.user.setHeight(this.historicUser.getHeight());
        this.user.setWidth(this.historicUser.getWidth());
    }

    public void run() {
        if (!this.isDirection()) {
            if (this.getUserX() < this.getStop()) {
                this.setUserX(this.getUserX() + this.getSpeed());
            } else {
                this.setUserX(this.getStart());
            }
        } else if (this.getUserX() > this.getStart()) {
            this.setUserX(this.getUserX() - this.getSpeed());
        } else {
            this.setUserX(this.getStop());
        }
        this.setChanged(true);
    }

    public void setUser() {
        this.setUser(this.user);
    }

    public void setUser(double d, double d2) {
        this.setUser(new Coordinates(d, d2));
    }

    public void setUser(Coordinates coordinates) {
        try {
            double d = ((Graph)this.e).calculate(coordinates.getWidth());
            this.user.setWidth(coordinates.getWidth());
            this.user.setHeight(d);
            this.setActive(true);
        }
        catch (Exception exception) {
            this.setActive(false);
        }
    }

    public void setUserX(double d) {
        this.user.setSize(d, this.user.getHeight());
    }

    public void setUserY(double d) {
        this.user.setSize(this.user.getWidth(), d);
    }

    public void storeUser() {
        if (this.user.getWidth() != this.historicUser.getWidth()) {
            this.historicUser.setWidth(this.user.getWidth());
            this.historicUser.setHeight(this.user.getHeight());
        }
    }

    public String shortInfo() {
        return this.generateShort(Geonext.language.getString("graphslider_short"));
    }
}

