/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.Intersection;
import geonext.JBoardPane;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Vector;
import util.Base64;
import util.IO;

public class Line
extends Element
implements MouseListener,
MouseMotionListener {
    Point A;
    Point B;
    public boolean arrow;
    public boolean first;
    public boolean last;
    public boolean editable = true;

    public Line() {
        this.initLine();
        this.A = new Point();
        this.A.setChanged(false);
        this.B = new Point();
        this.B.setChanged(false);
        this.setChanged(false);
    }

    public Line(Point point, Point point2, int n, int n2) {
        super("l" + n, n, n2);
        this.initLine();
        this.A = point;
        this.B = point2;
    }

    public Line(String string, int n, Point point, Point point2, int n2) {
        super(string, n, n2);
        this.initLine();
        this.A = point;
        this.B = point2;
    }

    public String description() {
        if (this.isFirst()) {
            if (this.isLast()) {
                return this.generateDesc(Geonext.language.getString("line_description_a"));
            }
            return this.generateDesc(Geonext.language.getString("line_description_b"));
        }
        if (this.isLast()) {
            return this.generateDesc(Geonext.language.getString("line_description_c"));
        }
        return this.generateDesc(Geonext.language.getString("line_description_d"));
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
    }

    public Coordinates center() {
        double d = this.B.getUserX() - this.A.getUserX();
        double d2 = this.B.getUserY() - this.A.getUserY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        return new Coordinates(this.A.getUserX() + d / 2.0, this.A.getUserY() + d2 / 2.0);
    }

    public Vector data() {
        Vector<Point> vector = new Vector<Point>();
        vector.addElement(this.getA());
        vector.addElement(this.getB());
        return vector;
    }

    double dist(double d, double d2, double d3, double d4) {
        return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            Color color;
            graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
            if (!this.isDraft()) {
                if (this.isMode() && jBoardPane.getModus() != 210260) {
                    graphics2D.setColor(this.getLighting());
                } else {
                    graphics2D.setColor(this.getStroke());
                }
                color = this.getLabel();
            } else {
                graphics2D.setColor(this.getDraftColor());
                color = this.getDraftColor();
            }
            this.drawImage(graphics2D, jBoardPane);
            Point point = new Point();
            Point point2 = new Point();
            Point point3 = new Point();
            Point point4 = new Point();
            point.setScreen(-10.0, -10.0);
            point2.setScreen(jBoardPane.getWidth() + 10, -10.0);
            point3.setScreen(-10.0, jBoardPane.getHeight() + 10);
            point4.setScreen(jBoardPane.getWidth() + 10, jBoardPane.getHeight() + 10);
            int n = graphics2D.getFontMetrics().getHeight() + 3;
            jBoardPane.screen2user(point);
            jBoardPane.screen2user(point2);
            jBoardPane.screen2user(point3);
            jBoardPane.screen2user(point4);
            point.user2sphere();
            point2.user2sphere();
            point3.user2sphere();
            point4.user2sphere();
            Line line = new Line(point, point2, 0, 0);
            Line line2 = new Line(point3, point4, 0, 0);
            Line line3 = new Line(point, point3, 0, 0);
            Line line4 = new Line(point2, point4, 0, 0);
            line.setMoved(true);
            line2.setMoved(true);
            line3.setMoved(true);
            line4.setMoved(true);
            Intersection intersection = new Intersection("", 0, this, line, 0, 0);
            Intersection intersection2 = new Intersection("", 0, this, line2, 0, 0);
            Intersection intersection3 = new Intersection("", 0, this, line3, 0, 0);
            Intersection intersection4 = new Intersection("", 0, this, line4, 0, 0);
            intersection.calculate(true);
            intersection2.calculate(true);
            intersection3.calculate(true);
            intersection4.calculate(true);
            jBoardPane.user2screen(intersection.getA());
            jBoardPane.user2screen(intersection2.getA());
            jBoardPane.user2screen(intersection3.getA());
            jBoardPane.user2screen(intersection4.getA());
            double d = this.getB().getScreenX() - this.getA().getScreenX();
            double d2 = this.getB().getScreenY() - this.getA().getScreenY();
            if (jBoardPane.in(d2 / d, -1.0, 1.0)) {
                if (this.getA().getScreenX() < this.getB().getScreenX()) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    if (this.isFirst() || this.getA().getScreenX() < 0.0) {
                        n5 = jBoardPane.round(intersection3.getA().getScreenX());
                        n4 = jBoardPane.round(intersection3.getA().getScreenY());
                    } else {
                        n5 = jBoardPane.round(this.getA().getScreenX());
                        n4 = jBoardPane.round(this.getA().getScreenY());
                    }
                    if (this.isLast() || this.getB().getScreenX() > (double)jBoardPane.getWidth()) {
                        n3 = jBoardPane.round(intersection4.getA().getScreenX());
                        n2 = jBoardPane.round(intersection4.getA().getScreenY());
                    } else {
                        n3 = jBoardPane.round(this.getB().getScreenX());
                        n2 = jBoardPane.round(this.getB().getScreenY());
                    }
                    double d3 = n3 - n5;
                    double d4 = n2 - n4;
                    double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                    graphics2D.drawLine(n5, n4, n3, n2);
                    if (this.isNameDrawed()) {
                        if (this.isFirst()) {
                            if (this.isTextName() && this.getNameText() != null) {
                                jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection.getA().getScreenX(), intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            } else {
                                jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection.getA().getScreenX(), intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            }
                        } else if (this.isLast()) {
                            if (this.isTextName() && this.getNameText() != null) {
                                jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(jBoardPane.min(jBoardPane.getWidth() - graphics2D.getFontMetrics().getHeight(), -15.0 - jBoardPane.min(-intersection.getA().getScreenX(), -intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection4.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            } else {
                                jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(jBoardPane.min(jBoardPane.getWidth() - graphics2D.getFontMetrics().getHeight(), -15.0 - jBoardPane.min(-intersection.getA().getScreenX(), -intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection4.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            }
                        } else if (this.isTextName() && this.getNameText() != null) {
                            jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth()) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                        } else {
                            jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth() - (double)(graphics2D.getFontMetrics().stringWidth(this.getName()) / 2)) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                        }
                    }
                } else {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    if (this.isLast() || this.getB().getScreenX() < 0.0) {
                        n9 = jBoardPane.round(intersection3.getA().getScreenX());
                        n8 = jBoardPane.round(intersection3.getA().getScreenY());
                    } else {
                        n9 = jBoardPane.round(this.getB().getScreenX());
                        n8 = jBoardPane.round(this.getB().getScreenY());
                    }
                    if (this.isFirst() || this.getA().getScreenX() > (double)jBoardPane.getWidth()) {
                        n7 = jBoardPane.round(intersection4.getA().getScreenX());
                        n6 = jBoardPane.round(intersection4.getA().getScreenY());
                    } else {
                        n7 = jBoardPane.round(this.getA().getScreenX());
                        n6 = jBoardPane.round(this.getA().getScreenY());
                    }
                    double d6 = n7 - n9;
                    double d7 = n6 - n8;
                    double d8 = Math.sqrt(d6 * d6 + d7 * d7);
                    graphics2D.drawLine(n9, n8, n7, n6);
                    if (this.isNameDrawed()) {
                        if (this.isFirst()) {
                            if (this.isTextName() && this.getNameText() != null) {
                                jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(jBoardPane.min(jBoardPane.getWidth() - graphics2D.getFontMetrics().getHeight(), -15.0 - jBoardPane.min(-intersection.getA().getScreenX(), -intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection4.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            } else {
                                jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(jBoardPane.min(jBoardPane.getWidth() - graphics2D.getFontMetrics().getHeight(), -15.0 - jBoardPane.min(-intersection.getA().getScreenX(), -intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection4.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            }
                        } else if (this.isLast()) {
                            if (this.isTextName() && this.getNameText() != null) {
                                jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection.getA().getScreenX(), intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            } else {
                                jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection.getA().getScreenX(), intersection2.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5)))), color, 0, 12);
                            }
                        } else if (this.isTextName() && this.getNameText() != null) {
                            jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth()) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                        } else {
                            jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth() - (double)(graphics2D.getFontMetrics().stringWidth(this.getName()) / 2)) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                        }
                    }
                }
            } else if (this.getA().getScreenY() < this.getB().getScreenY()) {
                int n10;
                int n11;
                int n12;
                int n13;
                if (this.isFirst() || this.getA().getScreenY() < 0.0) {
                    n13 = jBoardPane.round(intersection.getA().getScreenX());
                    n12 = jBoardPane.round(intersection.getA().getScreenY());
                } else {
                    n13 = jBoardPane.round(this.getA().getScreenX());
                    n12 = jBoardPane.round(this.getA().getScreenY());
                }
                if (this.isLast() || this.getB().getScreenY() > (double)jBoardPane.getHeight()) {
                    n11 = jBoardPane.round(intersection2.getA().getScreenX());
                    n10 = jBoardPane.round(intersection2.getA().getScreenY());
                } else {
                    n11 = jBoardPane.round(this.getB().getScreenX());
                    n10 = jBoardPane.round(this.getB().getScreenY());
                }
                double d9 = n11 - n13;
                double d10 = n10 - n12;
                double d11 = Math.sqrt(d9 * d9 + d10 * d10);
                graphics2D.drawLine(n13, n12, n11, n10);
                if (this.isNameDrawed()) {
                    if (this.isFirst()) {
                        if (this.isTextName() && this.getNameText() != null) {
                            jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection.getA().getScreenX(), jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName())))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), intersection4.getA().getScreenY()))), color, 0, 12);
                        } else {
                            jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection.getA().getScreenX(), jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName())))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), intersection4.getA().getScreenY()))), color, 0, 12);
                        }
                    } else if (this.isLast()) {
                        if (this.isTextName() && this.getNameText() != null) {
                            jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection2.getA().getScreenX(), jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName())))), jBoardPane.round(jBoardPane.min(jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5), -jBoardPane.min(-intersection3.getA().getScreenY(), -intersection4.getA().getScreenY()))), color, 0, 12);
                        } else {
                            jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(intersection2.getA().getScreenX(), jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName())))), jBoardPane.round(jBoardPane.min(jBoardPane.getHeight() - (jBoardPane.statusBar ? 5 + n : 5), -jBoardPane.min(-intersection3.getA().getScreenY(), -intersection4.getA().getScreenY()))), color, 0, 12);
                        }
                    } else if (this.isTextName() && this.getNameText() != null) {
                        jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth()) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                    } else {
                        jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth() - (double)(graphics2D.getFontMetrics().stringWidth(this.getName()) / 2)) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                    }
                }
            } else {
                int n14;
                int n15;
                int n16;
                int n17;
                if (this.isLast() || this.getB().getScreenY() < 0.0) {
                    n17 = jBoardPane.round(intersection.getA().getScreenX());
                    n16 = jBoardPane.round(intersection.getA().getScreenY());
                } else {
                    n17 = jBoardPane.round(this.getB().getScreenX());
                    n16 = jBoardPane.round(this.getB().getScreenY());
                }
                if (this.isFirst() || this.getA().getScreenY() > (double)jBoardPane.getHeight()) {
                    n15 = jBoardPane.round(intersection2.getA().getScreenX());
                    n14 = jBoardPane.round(intersection2.getA().getScreenY());
                } else {
                    n15 = jBoardPane.round(this.getA().getScreenX());
                    n14 = jBoardPane.round(this.getA().getScreenY());
                }
                double d12 = n15 - n17;
                double d13 = n14 - n16;
                double d14 = Math.sqrt(d12 * d12 + d13 * d13);
                graphics2D.drawLine(n17, n16, n15, n14);
                if (this.isNameDrawed()) {
                    if (this.isFirst()) {
                        if (this.isTextName() && this.getNameText() != null) {
                            jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName()), intersection2.getA().getScreenX()))), jBoardPane.round(jBoardPane.min(jBoardPane.getHeight(), -jBoardPane.min(-intersection3.getA().getScreenY(), -intersection4.getA().getScreenY())) - (double)(jBoardPane.statusBar ? 5 + n : 5)), color, 0, 12);
                        } else {
                            jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName()), intersection2.getA().getScreenX()))), jBoardPane.round(jBoardPane.min(jBoardPane.getHeight(), -jBoardPane.min(-intersection3.getA().getScreenY(), -intersection4.getA().getScreenY())) - (double)(jBoardPane.statusBar ? 5 + n : 5)), color, 0, 12);
                        }
                    } else if (this.isLast()) {
                        if (this.isTextName() && this.getNameText() != null) {
                            jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName()), intersection.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), intersection4.getA().getScreenY()))), color, 0, 12);
                        } else {
                            jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(10.0 - jBoardPane.min(0.0, -jBoardPane.min(jBoardPane.getWidth() - 20 - graphics2D.getFontMetrics().stringWidth(this.getName()), intersection.getA().getScreenX()))), jBoardPane.round(-jBoardPane.min(-graphics2D.getFontMetrics().getHeight(), -jBoardPane.min(intersection3.getA().getScreenY(), intersection4.getA().getScreenY()))), color, 0, 12);
                        }
                    } else if (this.isTextName() && this.getNameText() != null) {
                        jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth()) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                    } else {
                        jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(jBoardPane.user2screen(this.center()).getWidth() - (double)(graphics2D.getFontMetrics().stringWidth(this.getName()) / 2)) - 5, jBoardPane.round(jBoardPane.user2screen(this.center()).getHeight()), color, 0, 12);
                    }
                }
            }
        }
    }

    public boolean exists() {
        return this.A.exists() && this.B.exists() && this.A.userDistance(this.B) > 1.0E-9;
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterLine++;
        while (!bl) {
            while (n > -1) {
                string = "" + (char)(97 + n % 26) + string;
                n = (n - n % 26) / 26 - 1;
            }
            if (elementSet.searchName(string) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterLine;
        }
        this.setName(string);
    }

    public Point getA() {
        return this.A;
    }

    public int getElementKey() {
        if (this.isFirst()) {
            if (this.isLast()) {
                return 210250;
            }
            return 210240;
        }
        if (this.isLast()) {
            return 210240;
        }
        return 76;
    }

    public Point getB() {
        return this.B;
    }

    public String getElementName() {
        if (this.isFirst()) {
            if (this.isLast()) {
                return Geonext.language.getString("line_element_name_line");
            }
            return Geonext.language.getString("line_element_name_ray");
        }
        if (this.isLast()) {
            return Geonext.language.getString("line_element_name_ray");
        }
        return Geonext.language.getString("line_element_name_segment");
    }

    public String getElementname() {
        return this.getElementName();
    }

    public Coordinates getTextAnchor() {
        return new Coordinates((this.getA().getUserX() + this.getB().getUserX()) / 2.0, (this.getA().getUserY() + this.getB().getUserY()) / 2.0);
    }

    public Coordinates getTextAnchorScreen() {
        return new Coordinates((this.getA().getScreenX() + this.getB().getScreenX()) / 2.0, (this.getA().getScreenY() + this.getB().getScreenY()) / 2.0);
    }

    public void initLine() {
        this.area = 5;
        this.stroke = Color.blue;
        this.lighting = Color.cyan;
        this.label = new Color(0, 0, 0, 0);
        this.arrow = false;
        this.first = false;
        this.last = false;
        this.typeString = "line";
        this.setElementName(Geonext.language.getString("line_element_name"));
    }

    public boolean inLine(Point point) {
        if (!this.isFirst() && this.getB().userDistance(point) > this.getA().userDistance(point) && this.getA().userDistance(this.getB()) < this.getB().userDistance(point)) {
            return false;
        }
        return this.isLast() || !(this.getA().userDistance(point) > this.getB().userDistance(point)) || !(this.getA().userDistance(this.getB()) < this.getA().userDistance(point));
    }

    public boolean isArrow() {
        return this.arrow;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d = this.toLine(this.A, this.B, mouseEvent.getX(), mouseEvent.getY())[0];
        double d2 = this.toLine(this.A, this.B, mouseEvent.getX(), mouseEvent.getY())[1];
        double d3 = this.dist(d, d2, mouseEvent.getX(), mouseEvent.getY());
        double d4 = this.A.getScreenX() - this.B.getScreenX();
        double d5 = this.A.getScreenY() - this.B.getScreenY();
        double d6 = d5 * d5 + d4 * d4;
        if (Math.abs(d6) < 1.0E-5) {
            d6 = 1.0E-5;
        }
        d6 = Math.sqrt(d6);
        this.setMode(false);
        if (this.isVisible()) {
            if (this.first && this.last) {
                if (d3 < (double)this.area) {
                    this.setMode(true);
                }
            } else if (this.first) {
                if (d3 < (double)this.area & (this.dist(this.A.getScreenX(), this.A.getScreenY(), d, d2) < d6 - (double)this.area || this.dist(this.B.getScreenX(), this.B.getScreenY(), d, d2) > this.dist(this.A.getScreenX(), this.A.getScreenY(), d, d2))) {
                    this.setMode(true);
                }
            } else if (this.last) {
                if (d3 < (double)this.area & (this.dist(this.B.getScreenX(), this.B.getScreenY(), d, d2) < d6 - (double)this.area || this.dist(this.B.getScreenX(), this.B.getScreenY(), d, d2) < this.dist(this.A.getScreenX(), this.A.getScreenY(), d, d2))) {
                    this.setMode(true);
                }
            } else if (d3 < (double)this.area & this.dist(this.A.getScreenX(), this.A.getScreenY(), d, d2) < d6 - (double)this.area & this.dist(this.B.getScreenX(), this.B.getScreenY(), d, d2) < d6 - (double)this.area) {
                this.setMode(true);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            Point point = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "first")[1]);
            Point point2 = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "last")[1]);
            if (point == null || point2 == null || point.equals(point2)) {
                return false;
            }
            jBoardPane.createLine(point, point2, string2, false);
            Line line = (Line)jBoardPane.element.line.lastElement();
            string = line.parseProperties(jBoardPane, string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String parseProperties(JBoardPane jBoardPane, String string) {
        super.parseProperties(string);
        String string2 = this.tag(string, "straight")[1];
        this.setFirst(this.tag(string2, "first")[1]);
        this.setLast(this.tag(string2, "last")[1]);
        if (this.tag(string, "image")[1].length() > 0) {
            Object object;
            Image image = null;
            try {
                image = jBoardPane.getToolkit().createImage(Base64.decode(this.tag(string, "image")[1]));
                string = this.tag(string, "image")[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (image != null) {
                object = new MediaTracker(jBoardPane);
                ((MediaTracker)object).addImage(image, 1);
                try {
                    ((MediaTracker)object).waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.image = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                object = this.image.createGraphics();
                ((Graphics)object).drawImage(image, 0, 0, null);
            }
            catch (Exception exception) {
                this.image = null;
            }
        }
        return string;
    }

    public void setA(Point point) {
        this.A = point;
    }

    public void setArrow(boolean bl) {
        this.arrow = bl;
    }

    public void setB(Point point) {
        this.B = point;
    }

    public void setEditable(String string) {
        this.setEditable(new Boolean(string));
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setFirst(String string) {
        this.setFirst(new Boolean(string));
    }

    public void setFirst(boolean bl) {
        if (this.isEditable()) {
            this.first = bl;
        }
    }

    public void setLast(String string) {
        this.setLast(new Boolean(string));
    }

    public void setLast(boolean bl) {
        if (this.isEditable()) {
            this.last = bl;
        }
    }

    public String svg() {
        String string = new String();
        if (this.exists() && this.isVisible()) {
            int n = (int)Math.round(this.getA().getScreenX());
            int n2 = (int)Math.round(this.getA().getScreenY());
            int n3 = (int)Math.round(this.getB().getScreenX());
            int n4 = (int)Math.round(this.getB().getScreenY());
            if (!this.isDraft()) {
                string = string + "<line x1=\"" + n + "\" y1=\"" + n2 + "\" x2=\"" + n3 + "\" y2=\"" + n4 + "\" style=\"stroke-width:" + this.getStrokeWidth() + "; stroke:" + this.rgb2svgrgb(this.getStroke()) + "; fill:" + this.rgb2svgrgb(this.getStroke()) + "; stroke-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "\" />\n";
                string = string + "<text x=\"" + (int)this.getTextAnchorScreen().getWidth() + "\" y=\"" + (int)this.getTextAnchorScreen().getHeight() + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
                string = string + this.rgb2svgrgb(this.getLabel());
                string = string + "; fill-opacity:" + (double)this.getLabel().getAlpha() / 255.0;
                string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
                return string;
            }
            string = string + "<line x1=\"" + n + "\" y1=\"" + n2 + "\" x2=\"" + n3 + "\" y2=\"" + n4 + "\" style=\"stroke-width:" + this.getStrokeWidth() + "; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 + 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 - 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<text x=\"" + (int)this.getTextAnchorScreen().getWidth() + "\" y=\"" + (int)this.getTextAnchorScreen().getHeight() + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
            string = string + this.rgb2svgrgb(this.getDraftColor());
            string = string + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0;
            string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
            return string;
        }
        return string;
    }

    public double[] toLine(Point point, Point point2, double d, double d2) {
        double d3 = point.getScreenX() - point2.getScreenX();
        double d4 = point.getScreenY() - point2.getScreenY();
        double d5 = point2.getScreenX() * d4 - point2.getScreenY() * d3;
        double d6 = d * d3 + d2 * d4;
        double d7 = d4 * d4 + d3 * d3;
        if (Math.abs(d7) < 1.0E-5) {
            d7 = 1.0E-5;
        }
        double[] dArray = new double[]{(d5 * d4 + d6 * d3) / d7, (d6 * d4 - d5 * d3) / d7};
        return dArray;
    }

    public Point toUserLine(Point point) {
        double d = this.getA().getScreenX() - this.getB().getScreenX();
        double d2 = this.getA().getScreenY() - this.getB().getScreenY();
        double d3 = this.getB().getScreenX() * d2 - this.getB().getScreenY() * d;
        double d4 = point.getUserX() * d + point.getUserY() * d2;
        double d5 = d2 * d2 + d * d;
        if (Math.abs(d5) < 1.0E-5) {
            d5 = 1.0E-5;
        }
        double[] dArray = new double[]{(d3 * d2 + d4 * d) / d5, (d4 * d2 - d3 * d) / d5};
        Point point2 = new Point();
        point2.setUserX(dArray[0]);
        point2.setUserY(dArray[1]);
        return point2;
    }

    public Coordinates user2line(Coordinates coordinates) {
        return this.user2line(this, coordinates);
    }

    public Coordinates user2line(Line line, Coordinates coordinates) {
        double d = line.getA().getUserX() - line.getB().getUserX();
        double d2 = line.getA().getUserY() - line.getB().getUserY();
        double d3 = line.getB().getUserX() * d2 - line.getB().getUserY() * d;
        double d4 = coordinates.getWidth() * d + coordinates.getHeight() * d2;
        double d5 = d2 * d2 + d * d;
        if (Math.abs(d5) < 1.0E-10) {
            d5 = 1.0E-10;
        }
        return new Coordinates((d3 * d2 + d4 * d) / d5, (d4 * d2 - d3 * d) / d5);
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<first>" + this.getA().getId() + "</first>\n ";
        string2 = string2 + string + "<last>" + this.getB().getId() + "</last>\n ";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<straight>\n";
        string2 = string2 + string + "\t<first>" + this.isFirst() + "</first>\n";
        string2 = string2 + string + "\t<last>" + this.isLast() + "</last>\n";
        string2 = string2 + string + "</straight>\n";
        string2 = string2 + string + "<editable>" + this.isEditable() + "</editable>\n ";
        string2 = string2 + string + "<image>";
        if (this.getImage() != null) {
            string2 = string2 + Base64.encodeBytes(IO.image2byteArray(this.getImage()));
        }
        string2 = string2 + "</image>\n";
        return string2;
    }

    public String shortInfo() {
        if (this.getParent() != null) {
            return this.getParent().shortInfo();
        }
        if (this.isFirst()) {
            if (this.isLast()) {
                return this.generateShort(Geonext.language.getString("line_short_a"));
            }
            return this.generateShort(Geonext.language.getString("line_short_a"));
        }
        if (this.isLast()) {
            return this.generateShort(Geonext.language.getString("line_short_a"));
        }
        return this.generateShort(Geonext.language.getString("line_short_a"));
    }

    public void drawImage(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.getImage() != null) {
            try {
                double d = this.getA().getScreen().distance(this.getB().getScreen());
                double d2 = this.getImage().getWidth(null);
                double d3 = this.getImage().getHeight(null);
                Image image = this.getImage();
                image = image.getScaledInstance((int)d, (int)(d * d3 / d2), 2);
                MediaTracker mediaTracker = new MediaTracker(jBoardPane);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                d2 = image.getWidth(null);
                d3 = image.getHeight(null);
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                double d5 = Math.asin((this.getB().getScreenY() - this.getA().getScreenY()) / d);
                if (this.getA().getUserX() - this.getB().getUserX() > 0.0) {
                    d5 = -Math.PI + Math.asin((this.getA().getScreenY() - this.getB().getScreenY()) / this.getA().getScreen().distance(this.getB().getScreen()));
                }
                BufferedImage bufferedImage = new BufferedImage((int)d4, (int)d4, 2);
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                AffineTransform affineTransform = AffineTransform.getRotateInstance(d5, bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
                graphics2D2.setTransform(affineTransform);
                graphics2D2.drawImage(image, (int)(d4 - d2) / 2, (int)(d4 - d3) / 2, null);
                graphics2D.drawImage((Image)bufferedImage, (int)(this.getTextAnchorScreen().getWidth() - d4 / 2.0), (int)(this.getTextAnchorScreen().getHeight() - d4 / 2.0), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

